<?php
require 'config.php';
session_start();

$lead_id = $_POST['lead_id'];
$new_status_id = $_POST['new_status_id'];

// Ensure user is logged in and has proper role info
if (!isset($_SESSION['user_id']) || !isset($_SESSION['role'])) {
    http_response_code(403);
    echo "Unauthorized";
    exit;
}

$user_id = $_SESSION['user_id'];
$user_role = $_SESSION['role']; // 'admin' or 'broker'

// Fetch old status
$stmt_old = $conn->prepare("SELECT status_id FROM leads WHERE id = ?");
$stmt_old->bind_param("i", $lead_id);
$stmt_old->execute();
$stmt_old->bind_result($old_status_id);
$stmt_old->fetch();
$stmt_old->close();

// Update the leads table
$stmt = $conn->prepare("UPDATE leads SET status_id = ? WHERE id = ?");
$stmt->bind_param("ii", $new_status_id, $lead_id);
$stmt->execute();
$stmt->close();

// Log the status change with Dubai time
$stmt_log = $conn->prepare("INSERT INTO lead_status_logs 
    (lead_id, old_status_id, new_status_id, changed_by, changed_by_role, changed_at) 
    VALUES (?, ?, ?, ?, ?, CONVERT_TZ(NOW(), '+00:00', '+04:00'))");
$stmt_log->bind_param("iiiis", $lead_id, $old_status_id, $new_status_id, $user_id, $user_role);
$stmt_log->execute();
$stmt_log->close();

echo "✅ Lead status updated successfully!";
?>
