<?php
// /lib/permissions.php

// ✅ Prevents duplicate declaration of isAdmin()
if (!function_exists('isAdmin')) {
  function isAdmin(): bool {
    return ($_SESSION['role'] ?? null) === 'admin';
  }
}

// ✅ Prevents duplicate declaration of isBroker()
if (!function_exists('isBroker')) {
  function isBroker(): bool {
    return ($_SESSION['role'] ?? null) === 'broker';
  }
}

// ✅ Main helper: Check if broker is assigned to a lead
if (!function_exists('isBrokerAssignedToLead')) {
  function isBrokerAssignedToLead(int $leadId, int $brokerId): bool {
    global $db;
    if (!$db) return false;

    // DEBUG
    error_log("Check if broker $brokerId is assigned to lead $leadId");

    $stmt = $db->prepare("SELECT 1 FROM lead_broker_map WHERE lead_id = ? AND broker_id = ?");
    $stmt->bind_param("ii", $leadId, $brokerId);
    $stmt->execute();
    $result = $stmt->get_result();
    $found = $result && $result->num_rows > 0;
    $stmt->close();

    // DEBUG
    error_log("Result: " . ($found ? "YES" : "NO"));

    return $found;
  }
}

