<?php
// Start session only if not already active
//lib/auth.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Logs in a user (broker or admin) by email and password
function login($email, $password) {
    global $db;
    // Use unified users table, not deprecated brokers
$stmt = $db->prepare("SELECT id, password, role, name, profile_photo FROM users WHERE email = ?");

    $stmt->bind_param('s', $email);
    $stmt->execute();
    // Bind all 5 selected columns
$stmt->bind_result($id, $hash, $role, $name, $profile_photo);


    if ($stmt->fetch() && password_verify($password, $hash)) {
        $_SESSION['user_id'] = $id;
        $_SESSION['role']    = $role;
        $_SESSION['name']  = $name;
$_SESSION['photo'] = $profile_photo ?: '/assets/images/default_avatar.png';

        return true;
    }
    return false;
}

// Redirects user to login if they don't have the required role
function requireRole($role) {
    if (!isset($_SESSION['role']) || $_SESSION['role'] !== $role) {
        header('Location: /public/login.php'); // Update if your login page is elsewhere
        exit;
    }
}

// Checks if current session is an admin
function isAdmin() {
    return isset($_SESSION['role']) && $_SESSION['role'] === 'admin';
}

// Checks if current session is a broker
function isBroker() {
    return isset($_SESSION['role']) && $_SESSION['role'] === 'broker';
}

// Checks if any user is logged in
function isLoggedIn() {
    return isset($_SESSION['user_id']) && isset($_SESSION['role']);
}
