<?php
/**
 * init_monitored_sheets.php
 *
 * One-time script to seed your monitored_sheets table
 * from the monitored_sheets.json you already uploaded.
 */

// DEBUG: show errors on screen
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "<pre>✅ init_monitored_sheets.php loaded</pre>\n";

// Load your config (DB constants, paths, etc.)
require_once __DIR__ . '/../config.php';
echo "<pre>✅ config.php loaded</pre>\n";

// Connect to MySQL
$db = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($db->connect_errno) {
    exit("❌ DB connect error: " . $db->connect_error);
}
echo "<pre>✅ DB connected successfully</pre>\n";

// Read the JSON file you already uploaded
$jsonPath = __DIR__ . '/../google_api/monitored_sheets.json';
if (! file_exists($jsonPath)) {
    exit("❌ monitored_sheets.json not found at $jsonPath");
}

$json = file_get_contents($jsonPath);
$data = json_decode($json, true);
if (! isset($data['sources']) || ! is_array($data['sources'])) {
    exit("❌ Invalid JSON structure in monitored_sheets.json");
}

// Insert each source into the DB
$inserted = 0;
foreach ($data['sources'] as $src) {
    $sheetId = $db->real_escape_string($src['sheet_id']);
    $tabName = $db->real_escape_string($src['tab_name']);
    $lastRow = (int)$src['last_synced_row'];

    // Avoid duplicate seed
    $exists = $db->query("
        SELECT id 
        FROM monitored_sheets 
        WHERE sheet_id='$sheetId' 
          AND tab_name='$tabName'
    ");
    if ($exists->num_rows) {
        echo "<pre>ℹ️  Already exists: sheet_id=$sheetId, tab_name=$tabName</pre>\n";
        continue;
    }

    $sql = "
      INSERT INTO monitored_sheets 
        (sheet_id, tab_name, last_synced_row) 
      VALUES 
        ('$sheetId', '$tabName', $lastRow)
    ";
    if ($db->query($sql)) {
        echo "<pre>✅ Seeded: sheet_id=$sheetId, tab_name=$tabName, last_synced_row=$lastRow</pre>\n";
        $inserted++;
    } else {
        echo "<pre>❌ Failed to seed: " . $db->error . "</pre>\n";
    }
}

echo "<pre>🎉 Done. Total new entries: $inserted</pre>\n";

$db->close();
