<?php
session_start();
require_once '../config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || $_SESSION['role'] !== 'broker') {
    http_response_code(403);
    exit("Unauthorized");
}

$leadID = (int)($_POST['lead_id'] ?? 0);
$statusID = (int)($_POST['status_id'] ?? 0);
$brokerID = (int)$_SESSION['user_id'];

// Confirm lead belongs to broker
$stmt = $conn->prepare("UPDATE leads SET status_id = ?, broker_updated_at = NOW() WHERE id = ? AND broker_id = ?");
$stmt->bind_param("iii", $statusID, $leadID, $brokerID);
$stmt->execute();

header("Location: broker_dashboard.php");
exit;
