<?php
session_start();
require_once '../config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'broker') {
    header("Location: broker_login.php");
    exit;
}

$brokerId = $_SESSION['user_id'];
$statuses = $conn->query("SELECT * FROM lead_statuses ORDER BY id")->fetch_all(MYSQLI_ASSOC);

$stmt = $conn->prepare("SELECT * FROM leads WHERE broker_id = ? ORDER BY id DESC");
$stmt->bind_param("i", $brokerId);
$stmt->execute();
$res = $stmt->get_result();
?>

<!DOCTYPE html>
<html>
<head><title>Broker Dashboard</title></head>
<body>
  <h2>Welcome <?= htmlspecialchars($_SESSION["name"]) ?></h2>
  <a href="logout.php">Logout</a>
  <h3>Your Assigned Leads</h3>

  <table border="1" cellpadding="8">
    <tr>
      <th>ID</th>
      <th>Full Name</th>
      <th>Email</th>
      <th>Phone</th>
      <th>Status</th>
      <th>Update</th>
    </tr>
    <?php while ($row = $res->fetch_assoc()): 
        $data = json_decode($row['data'], true);
    ?>
    <tr>
      <td><?= $row['id'] ?></td>
      <td><?= htmlspecialchars($data['full_name'] ?? '') ?></td>
      <td><?= htmlspecialchars($data['email'] ?? '') ?></td>
      <td><?= htmlspecialchars($data['phone_number'] ?? '') ?></td>
      <td>
        <?php
        foreach ($statuses as $s) {
            if ($s['id'] == $row['status_id']) {
                echo htmlspecialchars($s['name']);
                break;
            }
        }
        ?>
      </td>
      <td>
        <form method="POST" action="update_status.php">
          <input type="hidden" name="lead_id" value="<?= $row['id'] ?>">
          <select name="status_id">
            <?php foreach ($statuses as $s): ?>
              <option value="<?= $s['id'] ?>" <?= $s['id'] == $row['status_id'] ? 'selected' : '' ?>>
                <?= htmlspecialchars($s['name']) ?>
              </option>
            <?php endforeach; ?>
          </select>
          <button type="submit">Update</button>
        </form>
      </td>
    </tr>
    <?php endwhile; ?>
  </table>
</body>
</html>
