<?php
session_start();
require_once __DIR__ . '/../config.php';

// allow only logged-in users
if (!isset($_SESSION['user_id'])) {
  http_response_code(403);
  header('Content-Type: application/json; charset=UTF-8');
  echo json_encode(['error' => 'Forbidden']);
  exit;
}

// set JSON header early
header('Content-Type: application/json; charset=UTF-8');

// validate range
$allowed = ['today','7days','30days','all'];
$range   = isset($_GET['range']) && in_array($_GET['range'], $allowed)
           ? $_GET['range']
           : 'all';

// build date filter
$where = [];
switch ($range) {
  case 'today':
    $where[] = "DATE(created_at) = CURDATE()";
    break;
  case '7days':
    $where[] = "created_at >= DATE_SUB(NOW(), INTERVAL 7 DAY)";
    break;
  case '30days':
    $where[] = "created_at >= DATE_SUB(NOW(), INTERVAL 30 DAY)";
    break;
  case 'all':
  default:
    // no WHERE clause
    break;
}

// run count query
$sql = "SELECT COUNT(*) AS cnt FROM leads"
     . ($where ? " WHERE " . implode(' AND ', $where) : "");
$stmt = $conn->prepare($sql);
$stmt->execute();
$res = $stmt->get_result()->fetch_assoc();

// output clean JSON and exit
echo json_encode(['count' => (int)$res['cnt']]);
exit;
