<?php
// api/get_lead_log_tabs.php
session_start();
require_once '../config.php';
require_once '../lib/auth.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
  echo json_encode(['success' => false, 'error' => 'Unauthorized']);
  exit;
}

$leadId = isset($_POST['lead_id']) ? (int)$_POST['lead_id'] : 0;
if ($leadId <= 0) {
  echo json_encode(['success' => false, 'error' => 'Invalid lead_id']);
  exit;
}

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
  echo json_encode(['success' => false, 'error' => 'DB connection failed']);
  exit;
}

// fetch assigned brokers
$stmt = $conn->prepare("
  SELECT u.id, u.name
  FROM lead_broker_map lbm
  JOIN users u ON u.id = lbm.broker_id AND u.role='broker'
  WHERE lbm.lead_id = ?
  ORDER BY u.name ASC
");
$stmt->bind_param('i', $leadId);
$stmt->execute();
$res = $stmt->get_result();

ob_start();
echo '<button data-broker="" class="logTabBtn px-3 py-1 rounded bg-blue-700 text-white text-sm">All</button>';
while ($row = $res->fetch_assoc()) {
  echo '<button data-broker="' . (int)$row['id'] . '" class="logTabBtn px-3 py-1 rounded bg-gray-700 text-gray-300 text-sm">'
      . htmlspecialchars($row['name'])
      . '</button>';
}
$html = ob_get_clean();

echo json_encode(['success' => true, 'html' => $html]);
$conn->close();
