<?php
// api/get_assign_ui.php
session_start();
require_once '../config.php';
require_once '../lib/auth.php';

header('Content-Type: application/json');
if (!isLoggedIn() || $_SESSION['role'] !== 'admin') {
  echo json_encode(['success' => false, 'error' => 'Unauthorized']);
  exit;
}

$leadId = isset($_POST['lead_id']) ? (int)$_POST['lead_id'] : 0;
if ($leadId <= 0) {
  echo json_encode(['success' => false, 'error' => 'Invalid lead_id']);
  exit;
}

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
  echo json_encode(['success' => false, 'error' => 'DB connection failed']);
  exit;
}

// fetch all active brokers
$brokers = [];
$res = $conn->query("SELECT id,name FROM users WHERE role='broker' AND status='active' ORDER BY name ASC");
while ($row = $res->fetch_assoc()) $brokers[] = $row;

// fetch already assigned
$assigned = [];
$stmt = $conn->prepare("SELECT broker_id FROM lead_broker_map WHERE lead_id=?");
$stmt->bind_param("i", $leadId);
$stmt->execute();
$res = $stmt->get_result();
while ($r = $res->fetch_assoc()) $assigned[] = (int)$r['broker_id'];
$stmt->close();

// unassigned list
$unassigned = array_filter($brokers, fn($b) => !in_array((int)$b['id'], $assigned, true));

ob_start();
if (!empty($unassigned)) {
  echo '<form id="assignBrokerForm" class="flex items-center gap-4 mb-6" data-lead-id="' . $leadId . '">';
  echo '<select id="newBrokerSelect" class="bg-gray-800 border border-gray-600 rounded p-2 text-white">';
  echo '<option value="" disabled selected>➕ Assign a broker...</option>';
  foreach ($unassigned as $ub) {
    echo '<option value="' . htmlspecialchars($ub['id']) . '">' . htmlspecialchars($ub['name']) . '</option>';
  }
  echo '</select>';
  echo '<button type="button" id="assignBrokerBtn" class="bg-accent hover:bg-blue-700 text-white px-4 py-2 rounded">Assign</button>';
  echo '</form>';
}
$html = ob_get_clean();

echo json_encode(['success' => true, 'html' => $html]);
$conn->close();
