<?php
// api/dashboard_trends.php
// New leads per day for last 30 days (role-scoped). JSON-only POST.

if (session_status() === PHP_SESSION_NONE) session_start();
header('Content-Type: application/json; charset=utf-8');

require_once '../config.php';
require_once '../lib/auth.php';
if (!isLoggedIn()) { http_response_code(401); echo json_encode(['ok'=>false,'error'=>'Unauthorized']); exit; }

$userId = (int)($_SESSION['user_id'] ?? 0);
$role   = $_SESSION['role'] ?? 'broker';

// JSON body (kept for future; no params required)
json_decode(file_get_contents('php://input'), true);

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) { http_response_code(500); echo json_encode(['ok'=>false,'error'=>'DB connection failed']); exit; }

// Base query: count by UTC date on leads.created_at
if ($role === 'broker') {
  $sql = "
    SELECT DATE(l.created_at) AS d, COUNT(*) AS c
    FROM leads l
    INNER JOIN lead_broker_map m ON m.lead_id = l.id AND m.broker_id = ?
    WHERE l.created_at >= (UTC_TIMESTAMP() - INTERVAL 29 DAY)
    GROUP BY DATE(l.created_at)
    ORDER BY d ASC";
  $stmt = $conn->prepare($sql);
  $stmt->bind_param('i', $userId);
} else {
  $sql = "
    SELECT DATE(l.created_at) AS d, COUNT(*) AS c
    FROM leads l
    WHERE l.created_at >= (UTC_TIMESTAMP() - INTERVAL 29 DAY)
    GROUP BY DATE(l.created_at)
    ORDER BY d ASC";
  $stmt = $conn->prepare($sql);
}

$rows = [];
if ($stmt && $stmt->execute()) {
  $res = $stmt->get_result();
  while ($r = $res->fetch_assoc()) $rows[$r['d']] = (int)$r['c'];
}
if ($stmt) $stmt->close();

// 0-fill last 30 days
$series = [];
$labels = [];
for ($i = 29; $i >= 0; $i--) {
  $d = (new DateTime('now', new DateTimeZone('UTC')))->sub(new DateInterval("P{$i}D"))->format('Y-m-d');
  $labels[] = $d;              // keep as UTC date string
  $series[] = $rows[$d] ?? 0;
}

echo json_encode(['ok'=>true, 'data'=>['labels'=>$labels, 'series'=>$series]], JSON_UNESCAPED_UNICODE);
