    <?php
// api/dashboard_timeseries.php
if (session_status()===PHP_SESSION_NONE) session_start();
header('Content-Type: application/json; charset=utf-8');
require_once '../config.php'; require_once '../lib/auth.php';
if (!isLoggedIn()) { http_response_code(401); echo json_encode(['ok'=>false,'error'=>'Unauthorized']); exit; }

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
$q = $conn->prepare("
  SELECT DATE(l.created_at) d, COUNT(*) c
  FROM leads l
  WHERE l.created_at >= (CURDATE() - INTERVAL 29 DAY)
  GROUP BY DATE(l.created_at)
  ORDER BY d ASC
");
$q->execute(); $res=$q->get_result();
$out=[]; while($r=$res->fetch_assoc()){ $out[]=['date'=>$r['d'],'count'=>(int)$r['c']]; }
echo json_encode(['ok'=>true,'data'=>$out], JSON_UNESCAPED_UNICODE);
