<?php
// api/dashboard_heatmap.php
// Follow-up counts per future day (next 6 weeks). Overdue excluded. Role-scoped.

if (session_status() === PHP_SESSION_NONE) session_start();
header('Content-Type: application/json; charset=utf-8');

require_once '../config.php';
require_once '../lib/auth.php';
if (!isLoggedIn()) { http_response_code(401); echo json_encode(['ok'=>false,'error'=>'Unauthorized']); exit; }

$userId = (int)($_SESSION['user_id'] ?? 0);
$role   = $_SESSION['role'] ?? 'broker';

$in = json_decode(file_get_contents('php://input'), true) ?: [];
$days = max(7, min(60, (int)($in['days'] ?? 42))); // default 6 weeks

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) { http_response_code(500); echo json_encode(['ok'=>false,'error'=>'DB connection failed']); exit; }

if ($role === 'broker') {
  $sql = "
    SELECT DATE(lbs.followup_datetime) AS d, COUNT(*) AS c
    FROM lead_broker_status lbs
    WHERE (lbs.deleted IS NULL OR lbs.deleted=0)
      AND lbs.broker_id=?
      AND lbs.followup_datetime IS NOT NULL
      AND lbs.followup_datetime >= CURDATE()
      AND lbs.followup_datetime < (CURDATE() + INTERVAL ? DAY)
    GROUP BY DATE(lbs.followup_datetime)
    ORDER BY d ASC";
  $stmt = $conn->prepare($sql);
  $stmt->bind_param('ii', $userId, $days);
} else {
  $sql = "
    SELECT DATE(lbs.followup_datetime) AS d, COUNT(*) AS c
    FROM lead_broker_status lbs
    WHERE (lbs.deleted IS NULL OR lbs.deleted=0)
      AND lbs.followup_datetime IS NOT NULL
      AND lbs.followup_datetime >= CURDATE()
      AND lbs.followup_datetime < (CURDATE() + INTERVAL ? DAY)
    GROUP BY DATE(lbs.followup_datetime)
    ORDER BY d ASC";
  $stmt = $conn->prepare($sql);
  $stmt->bind_param('i', $days);
}

$rows = [];
if ($stmt && $stmt->execute()) {
  $res = $stmt->get_result();
  while ($r = $res->fetch_assoc()) $rows[$r['d']] = (int)$r['c'];
}
if ($stmt) $stmt->close();

// 0-fill future window
$labels = []; $series = [];
$start = new DateTime('today', new DateTimeZone('UTC'));
for ($i=0; $i<$days; $i++) {
  $d = clone $start; $d->add(new DateInterval("P{$i}D"));
  $k = $d->format('Y-m-d');
  $labels[] = $k;
  $series[] = $rows[$k] ?? 0;
}
echo json_encode(['ok'=>true, 'data'=>['labels'=>$labels, 'series'=>$series]], JSON_UNESCAPED_UNICODE);
