<?php
// api/dashboard_funnel.php
// Current funnel counts by latest status per lead/broker. JSON-only POST.

if (session_status() === PHP_SESSION_NONE) session_start();
header('Content-Type: application/json; charset=utf-8');

require_once '../config.php';
require_once '../lib/auth.php';
if (!isLoggedIn()) { http_response_code(401); echo json_encode(['ok'=>false,'error'=>'Unauthorized']); exit; }

$userId = (int)($_SESSION['user_id'] ?? 0);
$role   = $_SESSION['role'] ?? 'broker';

// Order of funnel steps (IDs from your table)
$steps = [1,3,4,6,9,10];

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) { http_response_code(500); echo json_encode(['ok'=>false,'error'=>'DB connection failed']); exit; }

/* Find the latest row per lead in lead_broker_status (exclude deleted=1)
   Scope to broker when role=broker. */
if ($role === 'broker') {
  $sql = "
    SELECT x.status_id, COUNT(*) AS cnt
    FROM (
      SELECT lbs.lead_id, lbs.status_id
      FROM lead_broker_status lbs
      INNER JOIN (
        SELECT lead_id, MAX(updated_at) AS mu
        FROM lead_broker_status
        WHERE (deleted IS NULL OR deleted=0) AND broker_id=?
        GROUP BY lead_id
      ) t ON t.lead_id=lbs.lead_id AND t.mu=lbs.updated_at
      WHERE (lbs.deleted IS NULL OR lbs.deleted=0) AND lbs.broker_id=?
    ) x
    GROUP BY x.status_id";
  $stmt = $conn->prepare($sql);
  $stmt->bind_param('ii', $userId, $userId);
} else {
  $sql = "
    SELECT x.status_id, COUNT(*) AS cnt
    FROM (
      SELECT lbs.lead_id, lbs.status_id
      FROM lead_broker_status lbs
      INNER JOIN (
        SELECT lead_id, MAX(updated_at) AS mu
        FROM lead_broker_status
        WHERE (deleted IS NULL OR deleted=0)
        GROUP BY lead_id
      ) t ON t.lead_id=lbs.lead_id AND t.mu=lbs.updated_at
      WHERE (lbs.deleted IS NULL OR lbs.deleted=0)
    ) x
    GROUP BY x.status_id";
  $stmt = $conn->prepare($sql);
}

$map = [];
if ($stmt && $stmt->execute()) {
  $res = $stmt->get_result();
  while ($r = $res->fetch_assoc()) $map[(int)$r['status_id']] = (int)$r['cnt'];
}
if ($stmt) $stmt->close();

// Build funnel array in configured order
$out = [];
foreach ($steps as $sid) $out[] = ['status_id'=>$sid, 'count'=>($map[$sid] ?? 0)];

echo json_encode(['ok'=>true, 'data'=>$out], JSON_UNESCAPED_UNICODE);
