<?php
// api/contacted_leads.php
session_start();
require_once __DIR__ . '/../config.php';

// 🔐 Restrict to logged-in users
if (!isset($_SESSION['user_id'])) {
  http_response_code(403);
  header('Content-Type: application/json; charset=UTF-8');
  echo json_encode(['error' => 'Forbidden']);
  exit;
}

// 🧠 Set response type early
header('Content-Type: application/json; charset=UTF-8');

// ✅ Validate range
$allowed = ['today', '7days', '30days', 'all'];
$range = isset($_GET['range']) && in_array($_GET['range'], $allowed)
         ? $_GET['range']
         : 'all';

// 🗂 Build WHERE clause
$where = ["status_id = 3"]; // 📌 Contacted status ID

switch ($range) {
  case 'today':
    $where[] = "DATE(created_at) = CURDATE()";
    break;
  case '7days':
    $where[] = "created_at >= DATE_SUB(NOW(), INTERVAL 7 DAY)";
    break;
  case '30days':
    $where[] = "created_at >= DATE_SUB(NOW(), INTERVAL 30 DAY)";
    break;
  case 'all':
  default:
    // No additional filter
    break;
}

// 🔎 Run query
$sql = "SELECT COUNT(*) AS cnt FROM leads"
     . ($where ? " WHERE " . implode(' AND ', $where) : "");
$stmt = $conn->prepare($sql);
$stmt->execute();
$res = $stmt->get_result()->fetch_assoc();

// 📤 Output
echo json_encode(['count' => (int)$res['cnt']]);
exit;
