<?php
// admin/tools/repair_lead_broker_status.php
// ✅ Repair script to backfill missing lead_broker_status rows based on lead_broker_map

// 🔧 Enable full error reporting for debug purposes (remove in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// 🛡️ Secure access: only admins can run this
session_start();
header('Content-Type: application/json');

require_once '../../config.php';
require_once '../../lib/auth.php';

if (!isLoggedIn() || $_SESSION['role'] !== 'admin') {
  http_response_code(403);
  echo json_encode(['error' => 'Access denied. Admins only.']);
  exit;
}

// ✅ Connect to DB
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
  http_response_code(500);
  echo json_encode(['error' => 'DB connection failed: ' . $conn->connect_error]);
  exit;
}

// 🔍 Find broker-lead pairs in lead_broker_map missing from lead_broker_status
$query = "
  SELECT lbm.lead_id, lbm.broker_id
  FROM lead_broker_map lbm
  LEFT JOIN lead_broker_status lbs
    ON lbs.lead_id = lbm.lead_id AND lbs.broker_id = lbm.broker_id
  WHERE lbs.lead_id IS NULL
";

$result = $conn->query($query);
if (!$result) {
  http_response_code(500);
  echo json_encode(['error' => 'Query failed: ' . $conn->error]);
  $conn->close();
  exit;
}

$count = 0;

while ($row = $result->fetch_assoc()) {
  $insert = $conn->prepare("INSERT INTO lead_broker_status (lead_id, broker_id) VALUES (?, ?)");
  if (!$insert) continue;

  $insert->bind_param("ii", $row['lead_id'], $row['broker_id']);
  if ($insert->execute()) $count++;
  $insert->close();
}

$conn->close();

// ✅ Output result
echo json_encode([
  'success' => true,
  'inserted' => $count,
  'message' => "Inserted $count missing rows into lead_broker_status"
]);
