<?php
// admin/sidebar.php
?>
<aside
  id="sidebar"
  class="fixed top-12 left-0 w-48 h-[calc(100vh-3rem)] bg-surface border-r border-gray-800
         flex flex-col transition-all duration-300 ease-in-out z-40"
>

  <!-- Toggle Button -->
  <button id="toggleBtn" class="p-4 flex justify-end text-gray-100 focus:outline-none">
    <i class="fa-solid fa-bars text-xl"></i>
  </button>

  <!-- Navigation Links -->
  <nav class="flex-1 overflow-y-auto p-4 space-y-2">
    <?php
    $items = [
      'Dashboard' => ['fa-gauge', '/admin/admin_dashboard.php'],
      'Brokers'   => ['fa-user-tie', '/admin/brokers.php'],
      'Leads'     => ['fa-list', '/admin/leads.php'],
      'Sheets'    => ['fa-file-import', '/admin/manage_sheets.php'],
      'Reports'   => ['fa-chart-line', '/admin/reports.php'],
      'Settings'  => ['fa-cog', '/admin/settings.php'],
    ];
    foreach ($items as $label => [$icon, $url]): ?>
      <a href="<?= $url ?>" class="flex items-center p-2 space-x-3 hover:bg-gray-700 rounded">
        <i class="fa-solid <?= $icon ?> w-5 text-center"></i>
        <span class="link-label text-base font-medium"><?= $label ?></span>
      </a>
    <?php endforeach; ?>

    <a href="/admin/logout.php" class="flex items-center p-2 space-x-3 text-red-400 hover:bg-gray-700 rounded">
      <i class="fa-solid fa-right-from-bracket w-5 text-center"></i>
      <span class="link-label text-base font-medium">Logout</span>
    </a>
  </nav>
</aside>

<script>
  document.addEventListener('DOMContentLoaded', () => {
    const sidebar = document.getElementById('sidebar');
    const toggleBtn = document.getElementById('toggleBtn');
    const main = document.getElementById('mainContent');
    const labels = document.querySelectorAll('.link-label');
    let collapsed = false;

    function updateSidebar() {
      sidebar.classList.toggle('w-16', collapsed);
      sidebar.classList.toggle('w-48', !collapsed);
      main.classList.toggle('ml-16', collapsed);
      main.classList.toggle('ml-48', !collapsed);
      labels.forEach(label => {
        label.classList.toggle('hidden', collapsed);
      });
    }

    function initSidebar() {
      collapsed = window.innerWidth < 1024;
      updateSidebar();
    }

    toggleBtn.addEventListener('click', () => {
      collapsed = !collapsed;
      updateSidebar();
    });

    window.addEventListener('resize', () => {
      const shouldCollapse = window.innerWidth < 1024;
      if (shouldCollapse !== collapsed) {
        collapsed = shouldCollapse;
        updateSidebar();
      }
    });

    initSidebar();
  });
</script>
