<?php
session_start();
require_once '../config.php';
require_once '../lib/auth.php';

if (!isset($_SESSION["user_id"]) || $_SESSION["role"] !== 'admin') {
    header("Location: admin_login.php");
    exit;
}

$resets = $conn->query("SELECT * FROM reset_logs ORDER BY reset_time DESC")->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
  <title>Reset Logs</title>
  <style>
    table { border-collapse: collapse; width: 100%; margin-top: 20px; }
    th, td { border: 1px solid #ccc; padding: 8px; text-align: left; }
    th { background-color: #f2f2f2; }
    h1 { font-size: 24px; }
  </style>
</head>
<body>
  <h1>🕓 Reset Activity Logs</h1>
  <p><a href="admin_dashboard.php">⬅ Back to Dashboard</a></p>

  <table>
    <thead>
      <tr>
        <th>ID</th>
        <th>Admin ID</th>
        <th>Admin Name</th>
        <th>Reset Time (Dubai)</th>
        <th>IP Address</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($resets as $log): ?>
        <tr>
          <td><?= $log['id'] ?></td>
          <td><?= $log['admin_id'] ?></td>
          <td><?= htmlspecialchars($log['admin_name']) ?></td>
          <td><?= $log['reset_time'] ?></td>
          <td><?= $log['ip_address'] ?></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</body>
</html>
