<?php
session_start();
require_once '../config.php';
require_once '../lib/auth.php';

if (!isset($_SESSION["user_id"]) || $_SESSION["role"] !== 'admin') {
    header("Location: admin_login.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $adminId = $_SESSION['user_id'];
    $adminName = $_SESSION['name'] ?? 'Unknown Admin';
    $ipAddress = $_SERVER['REMOTE_ADDR'];
    $resetTime = (new DateTime('now', new DateTimeZone('Asia/Dubai')))->format('Y-m-d H:i:s');

    try {
        // Disable foreign key checks to allow truncation
        $conn->query("SET FOREIGN_KEY_CHECKS = 0");
        $conn->query("TRUNCATE TABLE leads");
        $conn->query("ALTER TABLE leads AUTO_INCREMENT = 1");
        $conn->query("SET FOREIGN_KEY_CHECKS = 1");

        // Reset sync pointers
        $conn->query("UPDATE monitored_sheets SET last_synced_row = 1");

        // ✅ Log reset activity
        $stmt = $conn->prepare("INSERT INTO reset_logs (admin_id, admin_name, reset_time, ip_address) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("isss", $adminId, $adminName, $resetTime, $ipAddress);
        $stmt->execute();
        $stmt->close();

        $message = "✅ Leads table reset and sync pointers updated.";
    } catch (Exception $e) {
        $message = "❌ Error: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html>
<head>
  <title>Reset Leads</title>
</head>
<body>
  <h2>Reset Leads Table</h2>
  <?php if (!empty($message)): ?>
    <p><strong><?= htmlspecialchars($message) ?></strong></p>
  <?php endif; ?>

  <form method="POST" onsubmit="return confirm('Are you sure you want to delete all leads and reset sync?');">
    <button type="submit">⚠️ Reset Leads Table</button>
  </form>

  <p><a href="admin_dashboard.php">⬅ Back to Dashboard</a></p>
</body>
</html>
