<section class="mb-12">
  <!-- ⚠️ JS handles JSON submission -->
  <form id="sheetForm" onsubmit="return false;"
        class="bg-gray-800 p-6 rounded-xl shadow space-y-6 max-w-screen-xl mx-auto">

    <!-- Section Header -->
    <h2 class="text-xl font-semibold text-white">📑 Add / Edit Sheet</h2>

    <!-- Form Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
      <!-- Sheet ID -->
      <div>
        <label for="sheet_id" class="block text-gray-300 mb-1">Sheet ID</label>
        <input type="text" id="sheet_id" placeholder="e.g. 1AbcDxyz123456789"
               class="w-full px-4 py-2 bg-gray-900 text-white border border-gray-700 rounded
                      focus:outline-none focus:ring focus:border-emerald-500" />
      </div>

      <!-- Tab Name -->
      <div>
        <label for="tab_name" class="block text-gray-300 mb-1">Tab Name</label>
        <input type="text" id="tab_name" placeholder="e.g. Leads"
               class="w-full px-4 py-2 bg-gray-900 text-white border border-gray-700 rounded
                      focus:outline-none focus:ring focus:border-emerald-500" />
      </div>

      <!-- Notes -->
      <div>
        <label for="notes" class="block text-gray-300 mb-1">Notes (optional)</label>
        <input type="text" id="notes" placeholder="e.g. Deyaar Campaign"
               class="w-full px-4 py-2 bg-gray-900 text-white border border-gray-700 rounded
                      focus:outline-none focus:ring focus:border-emerald-500" />
      </div>

      <!-- Last Synced Row -->
      <div>
        <label for="last_synced_row" class="block text-gray-300 mb-1">Last Synced Row</label>
        <input type="number" id="last_synced_row" placeholder="e.g. 10"
               class="w-full px-4 py-2 bg-gray-900 text-white border border-gray-700 rounded
                      focus:outline-none focus:ring focus:border-emerald-500" min="0" />
      </div>
    </div>

    <!-- Hidden Field for Updates -->
    <input type="hidden" id="sheet_id_field" />


    <!-- Buttons -->
    <div class="flex gap-4 pt-4">
      <button id="saveSheetBtn" type="button"
              class="bg-blue-600 hover:bg-blue-700 text-white font-medium px-6 py-2 rounded transition">
        Save
      </button>
      <button id="resetSheetBtn" type="button"
              class="bg-gray-600 hover:bg-gray-700 text-white font-medium px-6 py-2 rounded transition">
        Reset
      </button>
    </div>
  </form>
</section>
