<?php
// admin/partials/navbar/user_button.php
// User avatar + dropdown menu

require_once __DIR__ . '/../../../lib/auth.php';
if (!isLoggedIn()) exit;

// current user info from session
$userName = $_SESSION['user_name'] ?? 'User';
$userRole = $_SESSION['role'] ?? 'user';
$avatar   = $_SESSION['profile_photo'] ?? '/assets/images/default_avatar.png';
?>
<div class="relative">
  <!-- User button -->
  <button id="userBtn" class="flex items-center space-x-2 focus:outline-none">
    <img src="<?= htmlspecialchars($avatar) ?>" alt="Avatar"
         class="h-7 w-7 rounded-full border border-gray-600 object-cover">
    <span class="hidden md:inline-block text-sm font-medium">
      <?= htmlspecialchars($userName) ?>
    </span>
    <i class="fa-solid fa-caret-down text-xs"></i>
  </button>

  <!-- Dropdown -->
  <div id="userDropdownMenu"
       class="absolute right-0 mt-2 w-48 bg-gray-800 border border-gray-700 rounded-md shadow-lg
              opacity-0 scale-95 pointer-events-none transition transform origin-top-right z-50">
    <!-- Role display -->
    <div class="px-4 py-2 text-sm text-gray-400 border-b border-gray-700">
      Role: <?= ucfirst(htmlspecialchars($userRole)) ?>
    </div>

    <!-- Menu links -->
    <a href="/admin/profile.php"
       class="block px-4 py-2 text-sm hover:bg-gray-700">Profile</a>
    <a href="/admin/settings.php"
       class="block px-4 py-2 text-sm hover:bg-gray-700">Settings</a>
    <a href="/admin/logout.php"
       class="block px-4 py-2 text-sm text-red-400 hover:bg-gray-700">Logout</a>
  </div>
</div>
