<?php
// admin/partials/leads/leads_tabs.php
// -----------------------------------------------------------------------------
// Admin-only tab bar for the Leads page.
// Tabs: Unassigned, All Leads, and one tab per ACTIVE broker (users.role='broker').
// Relies on $conn from config.php; if missing (rare), we defensively include it.
// Buttons use the `.tabBtn` class and `data-tab` attribute (consumed by assets/js/leads.js).
// Now includes responsive broker initials + tooltip for mobile usability.
// -----------------------------------------------------------------------------

// âœ… Render only for admin
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
  return; // Do not render tabs for brokers
}

// âœ… Ensure DB connection is available (defensive)
if (!isset($conn) || !($conn instanceof mysqli)) {
  require_once dirname(__DIR__, 2) . '/config.php'; // brings $conn into scope if not present
}
?>
<!-- Leads View (admin only): simple select -->
<div class="mb-4">
  <label for="leadsTabSelect" class="text-sm text-gray-300 mb-1 block">Leads View</label>
  <select
    id="leadsTabSelect"
    class="w-80 rounded-md bg-gray-800 border border-gray-700 px-3 py-2 text-gray-100 focus:outline-none focus:ring-2 focus:ring-blue-500"
  >
    <option value="unassigned" selected>Unassigned</option>
    <option value="all">All Leads</option>
    <option value="" disabled>──────────</option>
    <?php
      if (!isset($conn) || !($conn instanceof mysqli)) {
        require_once dirname(__DIR__, 2) . '/config.php';
      }
      $sql = "SELECT id, name FROM users WHERE role='broker' ORDER BY name";
      if ($stmt = $conn->prepare($sql)) {
        $stmt->execute();
        $res = $stmt->get_result();
        while ($row = $res->fetch_assoc()):
          $bid = (int)$row['id'];
          $bname = htmlspecialchars($row['name'] ?? ('Broker #'.$bid), ENT_QUOTES, 'UTF-8');
          echo '<option value="'.$bid.'">'.$bname.'</option>';
        endwhile;
        $stmt->close();
      }
    ?>
  </select>
</div>

<!-- END: Broker dropdown -->

<!-- END: Broker picker (searchable datalist) -->

