<?php
// admin/partials/leads/leads_filter.php
// -----------------------------------------------------------------------------
// Search & filter bar used in leads.php (Admin and Broker view).
// -----------------------------------------------------------------------------
// JS will dynamically disable Status / Follow-up filters for:
//  - Admin on "All Leads" or "Unassigned" tab
//  - Search mode active (global search input used)
// -----------------------------------------------------------------------------

if (session_status() === PHP_SESSION_NONE) session_start();
$isAdmin = isset($_SESSION['role']) && $_SESSION['role'] === 'admin';

// Defensive DB include
if (!isset($conn) || !($conn instanceof mysqli)) {
  require_once dirname(__DIR__, 2) . '/config.php';
}
?>

<section id="leadsFilterBar" class="mb-4">
  <div class="flex flex-wrap items-end gap-3">



    <!-- 🔍 Search -->
    <div class="flex flex-col">
      <label for="leadsSearch" class="text-sm text-gray-300 mb-1">Search</label>
      <div class="relative">
        <input
          id="leadsSearch"
          type="text"
          class="w-56 rounded-md bg-gray-800 border border-gray-700 px-3 py-2 text-gray-100 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-blue-500"
          placeholder="Lead ID, name, email, phone, tab…"
          autocomplete="off"
        />
        <button
          id="clearSearchBtn"
          type="button"
          class="hidden absolute inset-y-0 right-0 mr-2 my-auto text-xs px-2 py-1 bg-gray-700 hover:bg-gray-600 rounded"
          aria-label="Clear search"
          title="Clear search"
        >Clear</button>
      </div>
    </div>

  <!-- 📅 Date Range -->
<div class="flex flex-col" data-filter="range"> <!-- ✅ move data-filter to wrapper -->
  <label for="leadsRange" class="text-sm text-gray-300 mb-1">Date Range</label>
  <select
  id="leadsRange"
  data-filter-type="range"
  data-filter="range"
  class="w-40 rounded-md bg-gray-800 border border-gray-700 px-3 py-2 text-gray-100 focus:outline-none focus:ring-2 focus:ring-blue-500"
>


        <option value="today">Today</option>
        <option value="7days">Last 7 days</option>
        <option value="30days" selected>Last 30 days</option>
        <option value="all">All time</option>
      </select>
    </div>

    <!-- 🏷️ Status (broker-only scope) -->
    <div class="flex flex-col">
      <label for="leadsStatus" class="text-sm text-gray-300 mb-1">Status</label>
      <select
  id="leadsStatus"
  data-filter-type="status"
  data-filter="status"
        class="w-44 rounded-md bg-gray-800 border border-gray-700 px-3 py-2 text-gray-100 focus:outline-none focus:ring-2 focus:ring-blue-500"
      >
        <option value="">All statuses</option>
        <?php
        $sql = "SELECT id, name FROM lead_statuses ORDER BY id";
        if ($stmt = $conn->prepare($sql)) {
          $stmt->execute();
          $res = $stmt->get_result();
          while ($row = $res->fetch_assoc()):
            $sid = (int)$row['id'];
            $sname = htmlspecialchars($row['name'], ENT_QUOTES, 'UTF-8');
            echo "<option value=\"{$sid}\">{$sname}</option>";
          endwhile;
          $stmt->close();
        } else {
          echo '<option disabled>Load failed</option>';
        }
        ?>
      </select>
    </div>

    <!-- 🏗️ Project -->
    <div class="flex flex-col">
      <label for="leadsProject" class="text-sm text-gray-300 mb-1">Project</label>
      <select
  id="leadsProject"
  data-filter-type="project"
  data-filter="project"
        class="w-52 rounded-md bg-gray-800 border border-gray-700 px-3 py-2 text-gray-100 focus:outline-none focus:ring-2 focus:ring-blue-500"
      >
        <option value="">All projects</option>
        <?php
        $pjSql = "SELECT DISTINCT tab_name FROM leads WHERE tab_name IS NOT NULL AND tab_name <> '' ORDER BY tab_name";
        if ($pjStmt = $conn->prepare($pjSql)) {
          $pjStmt->execute();
          $pjRes = $pjStmt->get_result();
          while ($pj = $pjRes->fetch_assoc()):
            $pname = htmlspecialchars($pj['tab_name'], ENT_QUOTES, 'UTF-8');
            echo "<option value=\"{$pname}\">{$pname}</option>";
          endwhile;
          $pjStmt->close();
        } else {
          echo '<option disabled>Load failed</option>';
        }
        ?>
      </select>
    </div>

    <!-- 📣 Platform -->
    <div class="flex flex-col">
      <label for="leadsPlatform" class="text-sm text-gray-300 mb-1">Platform</label>
      <select
  id="leadsPlatform"
  data-filter-type="platform"
  data-filter="platform"
        class="w-40 rounded-md bg-gray-800 border border-gray-700 px-3 py-2 text-gray-100 focus:outline-none focus:ring-2 focus:ring-blue-500"
      >
        <option value="">All platforms</option>
        <option value="Facebook">Facebook</option>
<option value="Instagram">Instagram</option>
<option value="Google">Google</option>
<option value="Unknown">Unknown</option>
      </select>
    </div>

    <!-- 🌍 Country -->
    <div class="flex flex-col">
      <label for="leadsCountry" class="text-sm text-gray-300 mb-1">Country</label>
      <select
  id="leadsCountry"
  data-filter-type="country"
  data-filter="country"
        class="w-44 rounded-md bg-gray-800 border border-gray-700 px-3 py-2 text-gray-100 focus:outline-none focus:ring-2 focus:ring-blue-500"
      >
        <option value="">All countries</option>
        <!-- JS will populate if needed -->
      </select>
    </div>

    <!-- ⏰ Follow-ups -->
    <div class="flex flex-col">
      <label for="leadsFollowups" class="text-sm text-gray-300 mb-1">Follow-ups</label>
      <select
  id="leadsFollowups"
  data-filter-type="followups"
  data-filter="followups"
        class="w-48 rounded-md bg-gray-800 border border-gray-700 px-3 py-2 text-gray-100 focus:outline-none focus:ring-2 focus:ring-blue-500"
      >
        <option value="">Any time</option>
        <option value="overdue">Overdue</option>
        <option value="today">Today</option>
        <option value="3d">Within 3 days</option>
        <option value="7d">Within 7 days</option>
        <option value="gt7">Beyond 7 days</option>
      </select>
    </div>

    <!-- ↕️ Sort -->
    <div class="flex flex-col">
      <label for="leadsSort" class="text-sm text-gray-300 mb-1">Sort By</label>
      <select
        id="leadsSort"
        class="w-48 rounded-md bg-gray-800 border border-gray-700 px-3 py-2 text-gray-100 focus:outline-none focus:ring-2 focus:ring-blue-500"
      >
        <option value="newest" selected>Newest first</option>
        <option value="oldest">Oldest first</option>
      </select>
    </div>

    <!-- 🔢 Per Page -->
    <div class="flex flex-col">
      <label for="leadsPerPage" class="text-sm text-gray-300 mb-1">Per Page</label>
      <select
        id="leadsPerPage"
        class="w-32 rounded-md bg-gray-800 border border-gray-700 px-3 py-2 text-gray-100 focus:outline-none focus:ring-2 focus:ring-blue-500"
      >
        <option value="10" selected>10</option>
        <option value="25">25</option>
        <option value="50">50</option>
      </select>
    </div>

   <!-- ✅ Live result count (updated by leads.js); aria-live for screen readers -->
   <div class="ml-auto mb-2">
     <span
       id="leadsResultCount"
       class="inline-flex items-center gap-1 rounded-full bg-gray-700 text-gray-100 text-sm px-3 py-1"
      aria-live="polite"
     >
      <!-- JS will inject: “Showing 1–10 of 42” or “0 results” -->
    </span>
   </div>

  <!-- 🧩 Hidden Role -->
   <input type="hidden" id="leadsUserRole" value="<?= $isAdmin ? 'admin' : 'broker' ?>">


    <!-- 🧩 Hidden Role -->
    <input type="hidden" id="leadsUserRole" value="<?= $isAdmin ? 'admin' : 'broker' ?>">
  </div>
</section>
