<?php
// admin/partials/leads/leads_empty.php
// -----------------------------------------------------------------------------
// Updated: Aug 2025
// This block is shown ONLY when no leads match the filters, tab, or search.
// JavaScript in leads.js toggles its visibility and updates the title message
// dynamically based on tab type (Unassigned, All Leads, Broker tabs).
// -----------------------------------------------------------------------------
// Uses: clearFiltersBtn, clearSearchBtnEmpty (hooked by JS)
// -----------------------------------------------------------------------------
?>

<div
  id="leadsEmptyState"
  class="hidden rounded-lg border border-gray-700 bg-gray-800 p-8 text-center shadow-md space-y-4"
>
  <!-- 🧭 Icon (visually consistent with rest of dark UI) -->
  <div class="mx-auto h-14 w-14 rounded-full bg-gray-700/60 flex items-center justify-center shadow">
    <i class="fas fa-search text-xl text-blue-400"></i>
  </div>

  <!-- 🚫 Dynamic Title (JS can override this text dynamically) -->
  <h2
    id="emptyStateTitle"
    class="text-lg font-semibold text-gray-100"
  >
    No leads found
  </h2>

  <!-- 💬 Suggestion Message -->
  <p class="text-sm text-gray-400">
    Try adjusting your filters or clearing the search to see more results.
  </p>

  <!-- 🔧 Action Buttons -->
  <div class="flex items-center justify-center gap-3 mt-4">
    <button
      id="clearFiltersBtn"
      type="button"
      class="px-4 py-2 rounded-md bg-gray-700 hover:bg-gray-600 text-gray-100 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500"
      title="Clear all filters"
    >
      <i class="fas fa-filter-slash mr-1"></i> Clear Filters
    </button>

    <button
      id="clearSearchBtnEmpty"
      type="button"
      class="px-4 py-2 rounded-md bg-gray-700 hover:bg-gray-600 text-gray-100 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500"
      title="Clear search"
    >
      <i class="fas fa-times-circle mr-1"></i> Clear Search
    </button>
  </div>
</div>
