<?php
// admin/partials/leads/leads_cards.php
// -----------------------------------------------------------------------------
// Patched: Unassigned leads show "Unassigned" badge, not "New Lead".
// "New Lead" only shown when status_id = 1 for an assigned broker.
// -----------------------------------------------------------------------------
?>

<div id="leadsCardsContainer" class="grid gap-4 grid-cols-1 sm:grid-cols-2"></div>
<div id="leadsPagination" class="mt-6 flex justify-center"></div>

<style>
  .badge { @apply inline-block px-2 py-0.5 text-xs font-semibold rounded-full whitespace-nowrap; }
  .badge-new       { @apply bg-blue-600 text-white; }
  .badge-overdue   { @apply bg-red-600 text-white; }
  .badge-today     { @apply bg-yellow-400 text-gray-900; }
  .badge-upcoming  { @apply bg-green-600 text-white; }
  .badge-status    { @apply bg-purple-600 text-white; }
  .badge-broker    { @apply bg-gray-700 text-white; }
  .badge-unassigned{ @apply bg-gray-600 text-white; }
</style>

<script type="text/template" id="leadCardTemplate">
  <div class="rounded-lg bg-gray-800 border border-gray-700 p-4 shadow-md hover:shadow-lg transition flex flex-col justify-between h-full">
    
    <!-- 🧩 Lead Header -->
    <header class="mb-3">
      <h3 class="text-base font-semibold text-gray-100 flex items-center mb-1">
        <i class="fas fa-user-circle mr-2 text-blue-400"></i>
        <%= lead_name || 'Unnamed Lead' %>
      </h3>
      <span class="text-xs text-blue-300 font-mono ml-2">Lead ID: <%= id %></span>

      <!-- 🔹 Lead Info -->
      <div class="text-xs text-gray-300 space-y-1 mt-2">
        <div class="flex items-center gap-2">
          <i class="fas fa-phone text-gray-500"></i>
          <%= lead_phone ? lead_phone.replace(/\d(?=\d{2})/g, '*') : '-' %>
        </div>
        <div class="flex items-center gap-2">
          <i class="fas fa-envelope text-gray-500"></i>
          <%= lead_email ? lead_email.replace(/(.{2}).+(@.+)/, '$1****$2') : '-' %>
        </div>
        <div class="flex items-center gap-2">
          <i class="fas fa-flag text-gray-500"></i>
          <%= country || '-' %>
        </div>
        <div class="flex items-center gap-2">
          <% 
            const icon = {
              facebook: 'fab fa-facebook-f',
              instagram: 'fab fa-instagram',
              google: 'fab fa-google'
            }[platform?.toLowerCase()] || 'fas fa-bullhorn';
          %>
          <i class="<%= icon %> text-gray-500"></i>
          <%= platform ? platform.charAt(0).toUpperCase() + platform.slice(1) : '-' %>
        </div>
        <div class="flex items-center gap-2">
          <i class="fas fa-folder text-gray-500"></i>
          <%= tab_name || '-' %>
        </div>
      </div>
    </header>

    <!-- 🏷️ Badges Section -->
    <div class="text-xs text-gray-300 space-y-2 mt-2">
      <div class="flex items-center gap-2">
        <% if (!Array.isArray(assigned_brokers) || assigned_brokers.length === 0) { %>
          <i class="fas fa-user-slash text-gray-400"></i>
          <span class="badge badge-unassigned">Unassigned</span>
        <% } else if (Array.isArray(broker_data) && broker_data.length) { %>
          <div class="flex flex-wrap items-center gap-1">
            <% broker_data.forEach(b => { if (b.status && b.broker_id !== null) { %>
              <span class="badge <%= b.status === 'New Lead' ? 'badge-new' : 'badge-status' %>">
                <%= b.broker_initials || '??' %>: <%= b.status %>
              </span>
            <% }}); %>
          </div>
        <% } else { %>
          <span class="text-gray-400">No status</span>
        <% } %>
      </div>
    </div>

    <!-- 🔗 Footer -->
    <footer class="flex justify-between items-center mt-4 text-xs text-gray-400">
      <a href="/admin/update_lead.php?id=<%= id %>" class="text-blue-400 hover:underline flex items-center gap-1">
        <i class="fas fa-edit"></i> View / Update
      </a>
      <div class="flex items-center gap-1">
        <i class="far fa-clock"></i> <%= created_at %>
      </div>
    </footer>
  </div>
</script>
