<?php
// admin/partials/lead_logs.php
// Single-column, compact timeline shell.
// NOTE: All visual styles for entries are now injected from JS (no @apply here).

?>
<section class="text-sm leading-snug">
  <h2 class="text-white font-semibold text-base mb-3">Lead Activity Timeline</h2>

<!-- Filter tabs -->
<div id="logTabsContainer" class="flex flex-wrap gap-2 mb-3">
  <?php
    if ($role === 'admin') {
      // Admin sees "All" and per-broker tabs
      echo '<button class="logTabBtn px-2.5 py-1 rounded bg-gray-800 text-gray-300 text-xs hover:bg-gray-700" data-broker="">All</button>';
      foreach ($assignedBrokers as $ab) {
        echo '<button class="logTabBtn px-2.5 py-1 rounded bg-gray-800 text-gray-300 text-xs hover:bg-gray-700" data-broker="' . (int)$ab['id'] . '">'
            . htmlspecialchars($ab['name'])
            . '</button>';
      }
    } else {
      // Broker: hide other brokers' tabs; load only own timeline silently
      echo '<button class="logTabBtn hidden" data-broker="' . (int)($_SESSION['user_id'] ?? 0) . '"></button>';
    }
  ?>
</div>



  <!-- Timeline loader/target -->
  <div id="leadLogsContainer" class="space-y-2">
    <div class="text-gray-400 text-xs italic">Loading activity...</div>
  </div>
</section>

<script>
// Auto-select first tab so logs load with the intended filter
document.addEventListener('DOMContentLoaded', () => {
  const btn = document.querySelector('.logTabBtn');
  if (btn) btn.click();
});
</script>
