<?php
// Get role and current user ID from session (already bootstrapped in parent file)
//admin/partials/lead_form.php

$role   = $_SESSION['role'];
$userId = $_SESSION['user_id'];
?>

<!-- 🗂️ Admin-only tab navigation for each assigned broker -->
<?php if ($role === 'admin'): ?>
  <div class="flex flex-wrap gap-2 mb-4">

    <?php foreach ($assignedBrokers as $index => $broker): ?>
      <button
  type="button"
  class="tabBtn px-4 py-1 rounded text-sm font-medium transition-all duration-200 
         <?= $index === 0 
            ? 'bg-blue-600 text-white shadow shadow-blue-600/30' 
            : 'bg-gray-700 text-gray-300 hover:bg-gray-600 hover:text-white' ?>"
  data-tab="brokerTab_<?= $broker['id'] ?>"
>
  <?= htmlspecialchars($broker['name']) ?>
</button>

    <?php endforeach; ?>
  </div>
<?php endif; ?>

<?php
// ✅ Track already rendered broker IDs to prevent duplicate display
$renderedBrokerIds = [];

foreach ($assignedBrokers as $index => $broker):
  $brokerId = $broker['id'];

  // ✅ Skip already rendered broker (fixes double form issue when admin's ID matches broker)
  if (in_array($brokerId, $renderedBrokerIds)) continue;
  $renderedBrokerIds[] = $brokerId;

  $statusId   = isset($broker['status_id']) && $broker['status_id'] !== null ? (int)$broker['status_id'] : 1;
  $followup   = $broker['followup_datetime'] ?? '';

  // ✅ Show form only if: (1) Admin or (2) current user is assigned broker
  $isVisible = ($role === 'admin') || ($userId == $brokerId);
  if (!$isVisible) continue;
?>

  <!-- 🔁 Broker-specific tab content -->
  <div
  id="brokerTab_<?= $brokerId ?>"
  class="brokerTab bg-gray-800/60 p-5 md:p-6 rounded-lg border border-gray-700 space-y-4 md:space-y-6 <?= ($role === 'admin' && $index !== 0) ? 'hidden' : '' ?>"
>


    <!-- 📝 Lead Update Form -->
    
<form 
  class="leadFormBlock space-y-3 text-[13px]"
  data-lead-id="<?= $leadId ?>"
  data-old-status-id="<?= (int)$statusId ?>"
  data-old-followup="<?= htmlspecialchars($followup ?: '') ?>"
  data-broker-id="<?= (int)$brokerId ?>"
  data-user-role="<?= htmlspecialchars($role) ?>"
  onsubmit="return false;"
>

  <!-- Row 1: Lead Status + Follow-up -->
  <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
    <!-- Lead Status -->
    <div>
      <label for="status_<?= $leadId ?>_<?= $brokerId ?>" class="block text-gray-400 mb-1 text-xs font-medium">
        Lead Status
      </label>
      <select
        id="status_<?= $leadId ?>_<?= $brokerId ?>"
        class="w-full bg-gray-800 border border-gray-700 rounded-md px-2 py-1.5 text-gray-100 focus:ring-1 focus:ring-blue-500 focus:border-blue-500"
      >
        <?php foreach ($statuses as $status): ?>
          <option value="<?= $status['id'] ?>" <?= $statusId == $status['id'] ? 'selected' : '' ?>>
            <?= htmlspecialchars($status['name']) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>

    <!-- Follow-up -->
    <div>
      <label for="followup_<?= $leadId ?>_<?= $brokerId ?>" class="block text-gray-400 mb-1 text-xs font-medium">
        Follow-up Date &amp; Time
      </label>
      <?php
        $followupValue = '';
        if (!empty($followup) && $followup !== '0000-00-00 00:00:00') {
          $ts = strtotime($followup);
          if ($ts) $followupValue = date('Y-m-d\TH:i', $ts);
        } else {
          $followupValue = date('Y-m-d\TH:i', strtotime('+1 day 09:00'));
        }
        $minValue = date('Y-m-d\TH:i');
      ?>
      <input
        type="datetime-local"
        id="followup_<?= $leadId ?>_<?= $brokerId ?>"
        value="<?= htmlspecialchars($followupValue) ?>"
        min="<?= $minValue ?>"
        class="w-full bg-gray-800 border border-gray-700 rounded-md px-2 py-1.5 text-gray-100 focus:ring-1 focus:ring-blue-500 focus:border-blue-500"
      />
      <p class="text-[11px] text-gray-500 mt-0.5">Select a future date &amp; time only</p>
      <p class="followupError hidden text-[11px] text-red-400 mt-0.5">Follow-up required for this status</p>
    </div>
  </div>

  <!-- Row 2: Quick Comment -->
  <div>
    <label for="quickComment_<?= $leadId ?>_<?= $brokerId ?>" class="block text-gray-400 mb-1 text-xs font-medium">
      Quick Comment
    </label>
    <select
      id="quickComment_<?= $leadId ?>_<?= $brokerId ?>"
      class="w-full bg-gray-800 border border-gray-700 rounded-md px-2 py-1.5 text-gray-100 focus:ring-1 focus:ring-blue-500 focus:border-blue-500"
    >
      <option value="">Select a quick comment...</option>
      <option value="Left voicemail, awaiting callback">Left voicemail, awaiting callback</option>
      <option value="Client requested project brochure">Client requested project brochure</option>
      <option value="Client busy, will call back later">Client busy, will call back later</option>
      <option value="Follow-up scheduled as discussed">Follow-up scheduled as discussed</option>
      <option value="Client not reachable, retry later">Client not reachable, retry later</option>
    </select>
  </div>

  <!-- Row 3: Comment -->
  <div>
    <label for="comment_<?= $leadId ?>_<?= $brokerId ?>" class="block text-gray-400 mb-1 text-xs font-medium">
      Comment
    </label>
    <textarea
      id="comment_<?= $leadId ?>_<?= $brokerId ?>"
      rows="3"
      class="w-full bg-gray-800 border border-gray-700 rounded-md px-2 py-1.5 text-gray-100 resize-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500"
    ></textarea>
    <p class="commentError hidden text-[11px] text-red-400 mt-0.5">Comment is required</p>
  </div>

  <!-- Row 4: Action Buttons -->
  <div class="flex items-center justify-between pt-2">
    <button
      type="button"
      class="submitBtn flex items-center gap-1 bg-blue-600 hover:bg-blue-700 text-white text-[13px] font-medium px-3 py-1.5 rounded-md shadow-sm transition"
    >
      <i class="fas fa-save text-[11px]"></i> Save Changes
    </button>

    <?php if ($role === 'admin'): ?>
      <button
        type="button"
        class="unassignBtn flex items-center gap-1 text-red-400 hover:text-red-300 text-[13px] font-medium"
        data-lead-id="<?= $leadId ?>" data-broker-id="<?= $brokerId ?>"
      >
        <i class="fas fa-user-slash text-[12px]"></i> Unassign
      </button>
    <?php endif; ?>
  </div>

  <!-- Snackbar -->
  <div class="snackbar mt-1 text-[11px] text-gray-400"></div>
</form>


  </div>

<?php endforeach; ?>
<!-- ✅ Ensure wrapper spacing is consistent -->
<div class="h-4"></div>

