<?php
// admin/partials/lead_details.php
require_once __DIR__ . '/../../lib/permissions.php';

// — assignment check
$brokerId = $_SESSION['user_id'] ?? null;
$assigned = false;
if ($_SESSION['role'] === 'broker' && $brokerId && $leadDetails['id']) {
    $assigned = isBrokerAssignedToLead((int)$leadDetails['id'], (int)$brokerId);
}
?>

<!-- CHANGE: add overflow-hidden + break-words to prevent long email/phone spill -->
<section class="bg-gray-800 p-6 rounded-lg shadow mb-6 overflow-hidden">
  <h2 class="text-lg font-semibold mb-4">
    <i class="fas fa-folder-open text-yellow-400 mr-2"></i> Lead Details
  </h2>

  <!-- CHANGE: add break-words on the grid to safely wrap long tokens -->
  <div class="grid grid-cols-1 md:grid-cols-3 gap-6 text-sm text-gray-300 break-words">
    <div><strong>Lead ID:</strong> <?= htmlspecialchars($leadDetails['id']) ?></div>
    <div><strong>Project:</strong> <?= htmlspecialchars($leadDetails['tab_name'] ?? '-') ?></div>
    <div><strong>Platform:</strong> <?= htmlspecialchars($leadDetails['platform'] ?? '-') ?></div>
    <div><strong>Full Name:</strong> <?= htmlspecialchars($leadDetails['full_name'] ?? '-') ?></div>
    <div><strong>Phone:</strong> <span class="break-all"><?= htmlspecialchars($leadDetails['phone_number'] ?? '-') ?></span></div>
    <div><strong>Email:</strong> <span class="break-all"><?= htmlspecialchars($leadDetails['email'] ?? '-') ?></span></div>
    <div><strong>Budget:</strong> <?= htmlspecialchars($leadDetails['budget'] ?? 'Not specified') ?></div>
    <div>
      <strong>Planning To Buy:</strong>
      <?= htmlspecialchars(mb_strimwidth($leadDetails['how_soon'] ?? 'Not specified', 0, 50, '...')) ?>
    </div>
    <div><strong>Country:</strong> <?= htmlspecialchars($leadDetails['country'] ?? '-') ?></div>
    <div><strong>Assigned Broker:</strong> <?= htmlspecialchars($leadDetails['assigned_broker'] ?? 'None') ?></div>
    <div><strong>Created At:</strong> <?= htmlspecialchars($leadDetails['created_at'] ?? '-') ?></div>
    <div><strong>Last Updated:</strong> <?= htmlspecialchars($leadDetails['updated_at'] ?? 'N/A') ?></div>
  </div>
</section>
