<!-- admin/partials/brokers/brokers_form.php -->

<section class="mb-12">
  <!-- ⚠️ Form does not submit directly. JS handles JSON fetch only -->
  <form id="brokerForm" onsubmit="return false;"
        class="bg-gray-800 p-6 rounded-xl shadow space-y-6 max-w-screen-xl mx-auto">

    <!-- Section Header -->
    <h2 class="text-xl font-semibold text-white">User Management</h2>

    <!-- Form Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
      
      <!-- Full Name -->
      <div>
        <label for="name" class="block text-gray-300 mb-1">Full Name</label>
        <input type="text" id="name" placeholder="Enter full name"
               class="w-full px-4 py-2 bg-gray-900 text-white border border-gray-700 rounded
                      focus:outline-none focus:ring focus:border-blue-500" />
      </div>

      <!-- Company Name -->
      <div>
        <label for="company_name" class="block text-gray-300 mb-1">Company Name</label>
        <input type="text" id="company_name" placeholder="Enter company name"
               class="w-full px-4 py-2 bg-gray-900 text-white border border-gray-700 rounded
                      focus:outline-none focus:ring focus:border-blue-500" />
      </div>

      <!-- Email -->
      <div>
        <label for="email" class="block text-gray-300 mb-1">Email</label>
        <input type="email" id="email" placeholder="Enter email"
               class="w-full px-4 py-2 bg-gray-900 text-white border border-gray-700 rounded
                      focus:outline-none focus:ring focus:border-blue-500" />
      </div>

      <!-- Phone -->
      <div>
        <label for="phone" class="block text-gray-300 mb-1">Phone</label>
        <input type="text" id="phone" placeholder="Enter phone number"
               class="w-full px-4 py-2 bg-gray-900 text-white border border-gray-700 rounded
                      focus:outline-none focus:ring focus:border-blue-500" />
      </div>

      <!-- Role -->
      <div>
        <label for="role" class="block text-gray-300 mb-1">Role</label>
        <select id="role"
                class="w-full px-4 py-2 bg-gray-900 text-white border border-gray-700 rounded
                       focus:outline-none focus:ring focus:border-blue-500">
          <option value="broker">Broker</option>
          <option value="admin">Admin</option>
        </select>
      </div>

      <!-- Status -->
      <div>
        <label for="status" class="block text-gray-300 mb-1">Status</label>
        <select id="status"
                class="w-full px-4 py-2 bg-gray-900 text-white border border-gray-700 rounded
                       focus:outline-none focus:ring focus:border-blue-500">
          <option value="active">Active</option>
          <option value="inactive">Inactive</option>
        </select>
      </div>

      <!-- Password (span full row) -->
      <div class="md:col-span-2 lg:col-span-3">
        <label for="password" class="block text-gray-300 mb-1">Password</label>
        <input type="password" id="password" placeholder="Leave blank to keep current password"
               class="w-full px-4 py-2 bg-gray-900 text-white border border-gray-700 rounded
                      focus:outline-none focus:ring focus:border-blue-500" />
      </div>

    </div>

    <!-- Buttons -->
    <div class="flex gap-4 pt-4">
      <button id="saveBtn" type="submit"
              class="bg-blue-600 hover:bg-blue-700 text-white font-medium px-6 py-2 rounded transition">
        Save
      </button>
      <button id="resetBtn" type="button"
              class="bg-gray-600 hover:bg-gray-700 text-white font-medium px-6 py-2 rounded transition">
        Reset
      </button>
    </div>

  </form>
</section>
