<?php
// admin/manage_sheets.php
session_start();
require_once '../config.php';
require_once '../lib/auth.php';

// 🔒 Admin-only access check
if (!isLoggedIn() || $_SESSION['role'] !== 'admin') {
    http_response_code(403);
    exit('Unauthorized');
}

// ✅ Page title for base layout
$pageTitle = "Manage Monitored Sheets";

// ✅ Buffer main content
ob_start();
?>

<!-- Page Header -->
<h1 class="text-2xl font-bold mb-6 text-white">Manage Monitored Sheets</h1>

<!-- Sync Button -->
<div class="mb-6">
  <button id="syncSheetsBtn"
          class="bg-emerald-600 hover:bg-emerald-700 text-white px-5 py-2 rounded text-sm font-medium transition">
    🔁 Sync to JSON
  </button>
</div>

<!-- Delete Confirmation Modal -->
<div id="deleteModal" class="hidden fixed inset-0 z-50 flex items-center justify-center">
  <!-- backdrop -->
  <div class="absolute inset-0 bg-black/60"></div>
  <!-- dialog -->
  <div class="relative w-full max-w-md bg-gray-800 text-gray-200 rounded-xl shadow-lg p-5 space-y-4">
    <h3 class="text-lg font-semibold">Delete Monitored Sheet</h3>

    <p class="text-sm">
      You are about to delete:
      <span id="modalSheetInfo" class="font-medium text-white"></span>
    </p>

    <!-- Choice: keep or delete leads -->
    <div class="space-y-2">
      <label class="flex items-center gap-2">
        <input id="modalChoiceKeep" type="radio" name="delChoice" class="h-4 w-4" checked>
        <span>Keep all imported leads</span>
      </label>
      <label class="flex items-center gap-2">
        <input id="modalChoiceDelete" type="radio" name="delChoice" class="h-4 w-4">
        <span>Also delete ALL leads that came from this sheet</span>
      </label>
    </div>

    <!-- Safety: type tab name to enable delete -->
    <div>
      <label class="block text-sm mb-1">Type the tab name to confirm</label>
      <input id="modalConfirmInput" type="text" class="w-full bg-gray-900 border border-gray-700 rounded px-3 py-2 text-sm" placeholder="Exact tab name">
      <p class="text-xs text-gray-400 mt-1">Deletion stays disabled until the tab name matches exactly.</p>
    </div>

    <div class="flex justify-end gap-3">
      <button id="modalCancelBtn" class="px-4 py-2 rounded bg-gray-700 hover:bg-gray-600 text-sm">Cancel</button>
      <button id="modalConfirmBtn" class="px-4 py-2 rounded bg-red-600 hover:bg-red-700 text-sm disabled:opacity-50" disabled>Delete</button>
    </div>
  </div>
</div>


<!-- 🧾 Sheet Form Partial -->
<?php include __DIR__ . '/partials/sheets/sheets_form.php'; ?>

<!-- 📋 Sheet Table Partial -->
<?php include __DIR__ . '/partials/sheets/sheets_table.php'; ?>
<?php include __DIR__ . '/partials/sheets/sheets_logs.php'; ?>

<!-- Inject JS after base_layout -->
<script type="module" src="/assets/js/sheets.js"></script>

<?php
$mainContent = ob_get_clean();
include 'base_layout.php';
?>
