<?php
// admin/leads.php
// -----------------------------------------------------------------------------
// Page: Leads (Admin & Broker)
// Uses base_layout.php via output buffering to inject $mainContent
// Renders role-aware tabs (admin only), shared filters, card grid container,
// empty-state placeholder, and a pagination container.
// All data is fetched/rendered by assets/js/leads.js via JSON (no FormData).
// -----------------------------------------------------------------------------

session_start();
require_once '../config.php';
require_once '../lib/auth.php';


// ✅ Restrict access to logged-in users (both admin and broker allowed)
if (!isset($_SESSION['user_id']) || !isset($_SESSION['role'])) {
    http_response_code(403);
    exit('Unauthorized');
}

// ✅ Set page title for layout and header
$pageTitle = "Leads";

// ✅ Buffer page content to inject into base_layout.php
ob_start();
?>

<!-- 🧭 Page Header -->
<h1 class="text-2xl font-bold mb-6 text-white">Leads</h1>

<?php
  // ✅ Show tabs only for admin (Unassigned / All / Per‑broker)
  if ($_SESSION['role'] === 'admin') {
      include __DIR__ . '/partials/leads/leads_tabs.php';
  }
?>

<!-- 🔎 Filters (visible to both admin and broker; admin may see extra controls internally) -->
<?php include __DIR__ . '/partials/leads/leads_filter.php'; ?>

<!-- 🚫 Empty State (JS toggles visibility based on API results) -->
<?php include __DIR__ . '/partials/leads/leads_empty.php'; ?>

<!-- 📦 Cards Grid Container (JS will render cards here) -->
<?php include __DIR__ . '/partials/leads/leads_cards.php'; ?>

<!-- 📄 Pagination Container (JS populates controls/results info here) -->
<div id="leadsPagination" class="mt-6 flex items-center justify-between gap-4"></div>

<!-- 📜 Load Leads module JS (ES module). Must be after the containers above. -->
<script type="module" src="/assets/js/leads.js"></script>

<?php
// ✅ Capture buffered content and render through the base layout shell
$mainContent = ob_get_clean();
include 'base_layout.php';
