<!-- admin/lead_log_modal.php -->

<!-- Lead Log Modal -->
<div id="logLeadActionModal" class="fixed inset-0 z-50 hidden bg-black/50 flex items-center justify-center">
  <div class="bg-white dark:bg-gray-800 p-6 rounded-lg w-full max-w-xl shadow-lg">
    <h2 class="text-xl font-semibold mb-4 text-gray-800 dark:text-white">Log Lead Activity</h2>

    <form id="leadLogForm">
      <input type="hidden" id="lead_id" name="lead_id" />

      <label class="block mb-2 text-sm font-medium text-gray-700 dark:text-gray-300">Action Type</label>
      <select id="action" name="action" class="w-full mb-4 border rounded p-2 dark:bg-gray-700 dark:text-white">
        <option value="status_update">Status Update</option>
        <option value="comment_only">Comment Only</option>
        <option value="reassignment">Reassign Broker</option>
      </select>

      <div id="statusFields" class="mb-4 hidden">
        <label class="block mb-1 text-sm font-medium text-gray-700 dark:text-gray-300">New Status</label>
        <select id="new_status_id" class="w-full border rounded p-2 dark:bg-gray-700 dark:text-white">
          <option value="">Select Status</option>
          <option value="2">Contacted</option>
          <option value="3">Engaged</option>
          <option value="4">Interested</option>
          <option value="5">Qualified</option>
          <option value="6">Site Visit Scheduled</option>
          <option value="7">Site Visit Done</option>
          <option value="8">Booking in Progress</option>
          <option value="9">Closed</option>
        </select>

        <label class="block mt-4 text-sm font-medium text-gray-700 dark:text-gray-300">Follow-Up Date & Time</label>
        <input type="datetime-local" id="followup_datetime" class="w-full border rounded p-2 dark:bg-gray-700 dark:text-white" />
      </div>

      <div id="reassignFields" class="mb-4 hidden">
        <label class="block mb-1 text-sm font-medium text-gray-700 dark:text-gray-300">Assign to Broker</label>
        <select id="new_broker_id" class="w-full border rounded p-2 dark:bg-gray-700 dark:text-white">
          <option value="">Select Broker</option>
          <option value="1">Broker A</option>
          <option value="2">Broker B</option>
          <option value="3">Broker C</option>
        </select>
      </div>

      <label class="block mb-1 text-sm font-medium text-gray-700 dark:text-gray-300">Comment</label>
      <textarea id="comment" class="w-full border rounded p-2 mb-4 dark:bg-gray-700 dark:text-white" rows="3"></textarea>

      <div class="flex justify-end space-x-2">
        <button type="button" onclick="closeLogModal()" class="bg-gray-400 text-white px-4 py-2 rounded">Cancel</button>
        <button type="submit" class="bg-green-600 text-white px-4 py-2 rounded">Submit</button>
      </div>
    </form>
  </div>
</div>

<script>
let currentLeadId = null;

function openLogLeadModal(leadId) {
  currentLeadId = leadId;
  document.getElementById('lead_id').value = leadId;
  document.getElementById('logLeadActionModal').classList.remove('hidden');
  document.getElementById('action').value = 'status_update';
  toggleActionFields();
}

function closeLogModal() {
  document.getElementById('logLeadActionModal').classList.add('hidden');
  document.getElementById('leadLogForm').reset();
  document.getElementById('followup_datetime').parentElement.style.display = 'none';
}

document.getElementById('action').addEventListener('change', toggleActionFields);

function toggleActionFields() {
  const action = document.getElementById('action').value;
  document.getElementById('statusFields').classList.toggle('hidden', action !== 'status_update');
  document.getElementById('reassignFields').classList.toggle('hidden', action !== 'reassignment');
}

document.getElementById('new_status_id').addEventListener('change', () => {
  const followupRequired = ['2', '3', '4', '5', '6', '7', '8'];
  const val = document.getElementById('new_status_id').value;
  document.getElementById('followup_datetime').parentElement.style.display = followupRequired.includes(val) ? 'block' : 'none';
});

document.getElementById('leadLogForm').addEventListener('submit', function(e) {
  e.preventDefault();
  const payload = {
    lead_id: currentLeadId,
    action: document.getElementById('action').value,
    comment: document.getElementById('comment').value
  };

  if (payload.action === 'status_update') {
    payload.old_status_id = null;
    payload.new_status_id = parseInt(document.getElementById('new_status_id').value);
    payload.followup_datetime = document.getElementById('followup_datetime').value || null;
  }

  if (payload.action === 'reassignment') {
    payload.old_broker_id = null;
    payload.new_broker_id = parseInt(document.getElementById('new_broker_id').value);
  }

  fetch('/api/log_lead_action.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify(payload)
  })
  .then(r => r.json())
  .then(data => {
    if (data.success) {
      alert('Lead action logged.');
      closeLogModal();
    } else {
      alert('Error: ' + data.error);
    }
  })
  .catch(err => {
    console.error(err);
    alert('Unexpected error.');
  });
});
</script>
