<?php
// header.php - Set up the header, styles, and required scripts
session_start(); // Start the session for session management
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Meta Tags -->
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>KCRE CRM - Admin Dashboard</title>

    <!-- AdminLTE CSS (from your local assets folder) -->
    <link rel="stylesheet" href="/assets/css/adminlte.min.css">

    <!-- Font Awesome Icons (For icons in buttons, navbar, sidebar) -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

    <!-- Custom Styles (Override AdminLTE styles or add custom styling here) -->
    <link rel="stylesheet" href="/assets/css/style.css">

    <!-- Optional Google Fonts (For typography) -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&family=Poppins:wght@400;600&display=swap" rel="stylesheet">
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <!-- Start the wrapper for the entire page -->
    <div class="wrapper">
        <!-- Main Header (Navbar) -->
        <nav class="main-header navbar navbar-expand navbar-dark bg-dark">
            <!-- Brand and Logo -->
            <a href="admin_dashboard.php" class="navbar-brand">
                <img src="/assets/img/logo.png" alt="Logo" class="brand-image">
                <span class="brand-text font-weight-light">Knight Castle</span>
            </a>

            <!-- Navbar Right Menu -->
            <ul class="navbar-nav ml-auto">
                <!-- User Info -->
                <li class="nav-item dropdown">
                    <a class="nav-link" href="#" data-toggle="dropdown">
                        <img src="/assets/img/avatar.png" class="user-avatar" alt="User Avatar"> 
                        <span class="user-name"><?= $_SESSION['name'] ?? 'Admin' ?></span> <!-- Dynamic user name -->
                    </a>
                    <div class="dropdown-menu dropdown-menu-right">
                        <a href="profile.php" class="dropdown-item">Profile</a>
                        <a href="logout.php" class="dropdown-item">Logout</a>
                    </div>
                </li>
            </ul>
        </nav>
        <!-- Sidebar and Content go here (To be added later) -->
    </div>
    <!-- Inline JavaScript for Dropdown -->
<script>
document.addEventListener('DOMContentLoaded', function () {
    const dropdownToggle = document.querySelector('.nav-link[data-toggle="dropdown"]');
    const dropdownMenu = document.querySelector('.dropdown-menu');

    // Toggle dropdown visibility when avatar is clicked
    dropdownToggle.addEventListener('click', function (event) {
        event.preventDefault();
        dropdownMenu.classList.toggle('show'); // Toggle visibility of dropdown menu
    });

    // Close dropdown if clicked outside of the dropdown
    document.addEventListener('click', function (event) {
        if (!dropdownMenu.contains(event.target) && !dropdownToggle.contains(event.target)) {
            dropdownMenu.classList.remove('show'); // Close dropdown
        }
    });
});
</script>

</body>

</html>
