<?php
// admin/feature_tracker.php
require_once '../lib/auth.php';
requireRole('admin'); // Admin only
if (session_status() === PHP_SESSION_NONE) session_start();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Admin Feature Tracker</title>

  <!-- Google Font: Inter -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600&display=swap" rel="stylesheet" />

  <!-- Tailwind CSS -->
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    tailwind.config = {
      darkMode: 'class',
      theme: {
        extend: {
          fontFamily: { sans: ['Inter', 'sans-serif'] },
          colors: { surface: '#1e293b', accent: '#2563eb' }
        }
      }
    };
  </script>

  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />
</head>
<body class="flex flex-col min-h-screen dark bg-gray-900 text-gray-100 font-sans">

  <?php include 'navbar.php'; ?>

  <div class="flex flex-1 relative pt-16 pb-24 min-h-[calc(100vh-4rem)]">
    <?php include 'sidebar.php'; ?>

    <main id="mainContent" class="p-6 transition-all duration-300 w-full ml-64">
      <h1 class="text-2xl font-semibold mb-6">🧱 Admin Feature Tracker</h1>

      <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <?php
        $features = [
          'Panel Layout' => [
            'Fixed Navbar' => true,
            'Collapsible Sidebar' => true,
            'Sticky Footer' => true,
            'AdminLTE Styling' => 'partial',
            'Mobile Responsive' => true,
          ],
          'Authentication & Roles' => [
            'Session Check' => true,
            'Role Restrictions' => true,
            'Admin/Broker Login' => true,
          ],
          'Leads Dashboard' => [
            'Lead Import from Sheets' => true,
            'Total Leads Tile' => true,
            'Contacted Leads Tile' => true,
            'More Tiles (Qualified, Site Visit, etc)' => 'partial',
            'Broker Filtering' => false,
          ],
          'Lead Management' => [
            'View/Edit Leads' => true,
            'JSON Data Parsing' => true,
            'Multi-Broker Assignment' => true,
            'Follow-up Required' => true,
            'Role-based Fields' => true,
          ],
          'Timeline & Logs' => [
            'Timeline Per Lead' => true,
            'Auto-Refresh' => true,
            'Filter by Type' => false,
            'Edit/Delete Logs' => false,
          ],
          'Advanced Tools' => [
            'Global Audit Log Viewer' => false,
            'Search/Filter Leads' => false,
            'Follow-ups Today View' => false,
            'CSV Export' => false,
            'WhatsApp Reminder' => false,
          ],
        ];

        foreach ($features as $section => $items): ?>
          <div class="bg-gray-800 rounded-xl p-4 shadow">
            <h2 class="text-lg font-semibold mb-3"><?= $section ?></h2>
            <ul class="space-y-1">
              <?php foreach ($items as $label => $status): ?>
                <li class="flex items-center gap-2">
                  <?php if ($status === true): ?>
                    <span class="text-green-400">✔</span>
                  <?php elseif ($status === 'partial'): ?>
                    <span class="text-yellow-400">▲</span>
                  <?php else: ?>
                    <span class="text-red-500">✘</span>
                  <?php endif; ?>
                  <span><?= htmlspecialchars($label) ?></span>
                </li>
              <?php endforeach; ?>
            </ul>
          </div>
        <?php endforeach; ?>
      </div>
    </main>
  </div>

  <?php include 'footer.php'; ?>

</body>
</html>
