<?php
// admin/brokers.php
session_start();
require_once '../config.php';
require_once '../lib/auth.php';


// ✅ Restrict access to admin users only
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    http_response_code(403);
    exit('Unauthorized');
}

// ✅ Set page title for layout and header
$pageTitle = "User Management";

// ✅ Buffer content
ob_start();
?>

<!-- Page header -->
<h1 class="text-2xl font-bold mb-6 text-white">User Management</h1>

<!-- ✅ Include broker form partial (corrected relative path) -->
<?php include __DIR__ . '/partials/brokers/brokers_form.php'; ?>

<!-- ✅ Include broker table partial -->
<?php include __DIR__ . '/partials/brokers/brokers_table.php'; ?>

<!-- ✅ Load broker module JS AFTER base_layout is rendered -->
<script type="module" src="/assets/js/brokers.js"></script>

<?php
$mainContent = ob_get_clean();
include 'base_layout.php';
?>
