<?php
// admin/base_layout.php
// Reusable admin layout wrapper – injects $mainContent from calling page

if (!isset($pageTitle)) $pageTitle = "Knight Castle Admin Panel";
?>
<!DOCTYPE html>
<html lang="en" class="dark">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title><?= htmlspecialchars($pageTitle) ?></title>

  <!-- Google Fonts: Inter -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap" rel="stylesheet" />

  <!-- Font Awesome -->
  <!-- ✅ Fixed: Removed broken integrity hash -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" crossorigin="anonymous" referrerpolicy="no-referrer" />

<!-- Chart.js (CDN) -->
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>



  <!-- Tailwind CSS (via CDN) -->
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    tailwind.config = {
      darkMode: 'class',
      theme: {
        extend: {
          fontFamily: { sans: ['Inter', 'sans-serif'] },
        },
      },
    };
  </script>

  <!-- Page Styles -->
  <style>
    body {
      font-family: 'Inter', sans-serif;
    }
  </style>
  <style>
  input:-webkit-autofill,
  input:-webkit-autofill:hover,
  input:-webkit-autofill:focus,
  input:-webkit-autofill:active {
    transition: background-color 5000s ease-in-out 0s;
    -webkit-text-fill-color: #f9fafb !important;
    background-color: #111827 !important;
    border-color: #374151 !important;
  }
</style>

</head>
<body class="flex flex-col min-h-screen bg-gray-900 text-gray-100">
    
  <?php include 'navbar.php'; ?>
  <?php include 'sidebar.php'; ?>

  <main id="mainContent" class="ml-64 p-6 pt-20 h-[calc(100vh-4rem)] overflow-y-auto space-y-6">

    <?= $mainContent ?>
  </main>

  <?php include 'footer.php'; ?>
  <!-- Navbar JS -->
  <script type="module" src="/assets/js/navbar.js"></script>


</body>
</html>
