<?php
// admin/audit_logs.php

if (session_status() === PHP_SESSION_NONE) session_start();
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../lib/auth.php';

if (!isLoggedIn() || $_SESSION['role'] !== 'admin') {
  http_response_code(403);
  exit('Unauthorized');
}

require_once 'navbar.php';
require_once 'sidebar.php';

$db = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// 🧠 Pull all logs sorted by most recent
$query = "
  SELECT l.*, b.name AS user_name
  FROM lead_logs l
  LEFT JOIN brokers b ON b.id = l.changed_by
  ORDER BY l.created_at DESC
";
$result = $db->query($query);
$logs = $result ? $result->fetch_all(MYSQLI_ASSOC) : [];

?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Audit Logs - Knight Castle CRM</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="dark bg-gray-900 text-gray-100 font-sans">
  <div class="flex flex-col min-h-screen">
    <main class="ml-64 mt-16 p-6 h-[calc(100vh-4rem)] overflow-y-auto">
      <h1 class="text-2xl font-bold mb-6">🧾 System Audit Logs</h1>

      <div class="bg-gray-800 rounded-lg p-4 overflow-x-auto shadow">
        <table class="w-full text-sm table-auto border-collapse">
          <thead>
            <tr class="bg-gray-700 text-left">
              <th class="p-2">#</th>
              <th class="p-2">Lead ID</th>
              <th class="p-2">Action</th>
              <th class="p-2">Comment</th>
              <th class="p-2">Changed By</th>
              <th class="p-2">Role</th>
              <th class="p-2">At</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($logs as $i => $log): ?>
              <tr class="border-b border-gray-700">
                <td class="p-2"><?= $i + 1 ?></td>
                <td class="p-2"><?= htmlspecialchars($log['lead_id']) ?></td>
                <td class="p-2 uppercase text-xs"><?= htmlspecialchars($log['action']) ?></td>
                <td class="p-2"><?= htmlspecialchars($log['comment']) ?></td>
                <td class="p-2"><?= htmlspecialchars($log['user_name'] ?? 'Unknown') ?></td>
                <td class="p-2"><?= htmlspecialchars($log['role']) ?></td>
                <td class="p-2"><?= htmlspecialchars($log['created_at']) ?></td>
              </tr>
            <?php endforeach; ?>
            <?php if (empty($logs)): ?>
              <tr><td colspan="7" class="p-4 text-gray-400">No logs found.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </main>
  </div>
  <?php require_once 'footer.php'; ?>
</body>
</html>
