<?php
session_start();
require_once '../config.php';
require_once __DIR__ . '/../lib/auth.php';

$error = '';

// Handle login
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = trim($_POST["email"]);
    $password = $_POST["password"];

    $stmt = $conn->prepare("SELECT * FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $res = $stmt->get_result();

    if ($res->num_rows === 1) {
        $user = $res->fetch_assoc();
        if (password_verify($password, $user["password"])) {
            $_SESSION["user_id"] = (int)$user["id"];
            $_SESSION["role"]    = $user["role"];
            $_SESSION["name"]    = $user["name"];

            if ($user["role"] === "broker") {
                $_SESSION["broker_id"] = $user["id"];
            }

            header("Location: admin_dashboard.php");
            exit;
        } else {
            $error = "Invalid password.";
        }
    } else {
        $error = "No user found with this email.";
    }
}

// Redirect if already logged in
if (isset($_SESSION['user_id'])) {
    header("Location: admin_dashboard.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Admin Login</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-900 flex items-center justify-center h-screen text-white font-sans">
  <div class="w-full max-w-sm bg-gray-800 p-6 rounded-lg shadow-md">

    <!-- Logo -->
    <div class="flex justify-center mb-4">
      <img src="/assets/images/knight-logo.png" alt="Knight Castle Logo" class="h-16 rounded-full shadow-lg">
    </div>

    <!-- Heading -->
    <h2 class="text-2xl font-bold mb-6 text-center">Knight Castle CRM</h2>

    <!-- Error Message -->
    <?php if ($error): ?>
      <div class="bg-red-500 text-white text-sm px-4 py-2 rounded mb-4">
        <?= htmlspecialchars($error) ?>
      </div>
    <?php endif; ?>

    <!-- Login Form -->
    <form method="POST" action="admin_login.php" class="space-y-4">
      <div>
        <label for="email" class="block text-sm font-medium text-gray-200">Email</label>
        <input type="email" name="email" id="email" required
          class="w-full px-3 py-2 rounded bg-gray-700 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-blue-500">
      </div>

      <div>
        <label for="password" class="block text-sm font-medium text-gray-200">Password</label>
        <input type="password" name="password" id="password" required
          class="w-full px-3 py-2 rounded bg-gray-700 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-blue-500">
      </div>

      <button type="submit"
        class="w-full py-2 px-4 bg-blue-600 hover:bg-blue-700 rounded text-white font-semibold transition duration-150">
        Login
      </button>
    </form>
  </div>
</body>
</html>
