<?php
// admin/admin_dashboard.php
// Uses base_layout.php via output buffering to inject $mainContent (same as leads.php).

if (session_status() === PHP_SESSION_NONE) session_start();
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../lib/auth.php';

if (!isLoggedIn()) {
  header('Content-Type: application/json; charset=utf-8');
  http_response_code(401);
  echo json_encode(['ok' => false, 'error' => 'Unauthorized']);
  exit;
}

$role = $_SESSION['role'] ?? 'broker';
$pageTitle = "Dashboard";             // <-- provide title to base_layout

ob_start();                           // <-- start buffering page body (NO <main> here)
?>

<h1 class="text-2xl font-bold mb-6 text-white">Dashboard</h1>

<!-- Overdue Alert (hidden by JS when zero) -->
<div id="overdueAlert" class="mb-4 hidden bg-red-900/40 border border-red-700 text-red-200 px-4 py-3 rounded">
  <span id="overdueMsg">⚠️ You have overdue follow-ups</span>
  <a href="/admin/leads.php?tab=all&followup=overdue" class="ml-3 underline text-red-300">View</a>
</div>


<!-- Tiles grid -->
<section id="tiles" class="grid grid-cols-1 md:grid-cols-3 gap-4">
  <!-- New Leads -->
  <div class="bg-gray-800 rounded-xl p-4 shadow">
    <div class="text-sm text-gray-400">New Leads</div>
    <div class="mt-3 flex items-end gap-6">
      <a href="/admin/leads.php?tab=all&range=today" class="group">
        <div class="text-3xl font-bold group-hover:underline" id="newToday">0</div>
        <div class="text-xs text-gray-400">Today</div>
      </a>
      <a href="/admin/leads.php?tab=all&range=7d" class="group">
        <div class="text-3xl font-bold group-hover:underline" id="new7d">0</div>
        <div class="text-xs text-gray-400">Last 7d</div>
      </a>
      <a href="/admin/leads.php?tab=all&range=30d" class="group">
        <div class="text-3xl font-bold group-hover:underline" id="new30d">0</div>
        <div class="text-xs text-gray-400">Last 30d</div>
      </a>
    </div>
  </div>

  <!-- Unassigned (admin only) -->
  <div class="bg-gray-800 rounded-xl p-4 shadow <?php echo ($role === 'admin') ? '' : 'hidden'; ?>">
    <div class="text-sm text-gray-400">Unassigned Leads</div>
    <a href="/admin/leads.php?tab=unassigned" class="block mt-3">
      <div class="text-4xl font-bold hover:underline" id="unassigned">0</div>
    </a>
  </div>

  <!-- Follow-ups -->
  <div class="bg-gray-800 rounded-xl p-4 shadow">
    <div class="text-sm text-gray-400">Follow-ups</div>
    <div class="mt-3 grid grid-cols-4 gap-3 text-center">
      <a href="/admin/leads.php?tab=all&followup=overdue" class="block group">
        <div class="text-xl font-bold group-hover:underline" id="fuOverdue">0</div>
        <div class="text-xs text-red-400">Overdue</div>
      </a>
      <a href="/admin/leads.php?tab=all&followup=today" class="block group">
        <div class="text-xl font-bold group-hover:underline" id="fuToday">0</div>
        <div class="text-xs text-gray-400">Today</div>
      </a>
      <a href="/admin/leads.php?tab=all&followup=3d" class="block group">
        <div class="text-xl font-bold group-hover:underline" id="fu3d">0</div>
        <div class="text-xs text-gray-400">Next 3d</div>
      </a>
      <a href="/admin/leads.php?tab=all&followup=7d" class="block group">
        <div class="text-xl font-bold group-hover:underline" id="fu7d">0</div>
        <div class="text-xs text-gray-400">Next 7d</div>
      </a>
    </div>
  </div>
</section>

<!-- Distributions -->
<section class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-6">
  <div class="bg-gray-800 rounded-xl p-4 shadow">
    <div class="text-sm text-gray-400 mb-2">Status distribution</div>
    <ul id="statusList" class="space-y-2 text-sm"></ul>
  </div>
  <div class="bg-gray-800 rounded-xl p-4 shadow">
    <div class="text-sm text-gray-400 mb-2">Platforms</div>
    <ul id="platformList" class="space-y-2 text-sm"></ul>
  </div>
</section>

<!-- Trends & Funnel -->
<section class="grid grid-cols-1 lg:grid-cols-2 gap-4 mt-6">
  <div class="bg-gray-800 rounded-xl p-4 shadow">
    <div class="text-sm text-gray-400 mb-2">New Leads (last 30 days)</div>
    <canvas id="leadsTrend" height="120"></canvas>
  </div>
  <div class="bg-gray-800 rounded-xl p-4 shadow">
    <div class="text-sm text-gray-400 mb-2">Conversion Funnel</div>
    <canvas id="funnelChart" height="120"></canvas>
  </div>
</section>

<!-- Leaderboard & Heatmap -->
<section class="grid grid-cols-1 lg:grid-cols-2 gap-4 mt-6">
  <div id="leaderboardCard" class="bg-gray-800 rounded-xl p-4 shadow <?php echo ($role === 'admin') ? '' : 'hidden'; ?>">
    <div class="text-sm text-gray-400 mb-2">Broker Leaderboard (last 30 days)</div>

      <!-- FIX: restrict scroll + min-width to small screens only -->
  <div class="sm:overflow-x-visible overflow-x-auto -mx-4 sm:mx-0">
    <table id="leaderboardTable"
           class="sm:min-w-0 min-w-[640px] w-full text-xs sm:text-sm sm:whitespace-normal whitespace-nowrap">

        <thead class="text-gray-400">
          <tr>
            <th class="text-left py-2 px-2">Broker</th>
            <th class="text-right px-2">Assigned</th>
            <th class="text-right px-2">FU Done</th>
            <th class="text-right px-2">Qualified</th>
            <th class="text-right px-2">Booked</th>
            <!-- HIDE 'Closed' on very small screens to reduce overflow -->
            <th class="text-right px-2 hidden sm:table-cell">Closed</th>
          </tr>
        </thead>
        <tbody class="divide-y divide-gray-700 text-gray-200"></tbody>
      </table>
    </div>
  </div>  <!-- ✅ CLOSE leaderboardCard BEFORE heatmap -->

  <div class="bg-gray-800 rounded-xl p-4 shadow">
    <div class="text-sm text-gray-400 mb-2">Follow-up Heatmap (next 6 weeks)</div>
    <canvas id="heatmapChart" height="160"></canvas>
  </div>
</section>



<!-- Follow-ups to act on -->
<section class="mt-6">
  <div class="bg-gray-800 rounded-xl p-4 shadow">
    <div class="flex items-center justify-between mb-3">
      <div class="text-sm text-gray-400">Follow-ups to act on</div>
      <a id="fuViewAll" href="/admin/leads.php?tab=all&followup=overdue" class="text-xs text-blue-400 hover:underline">View all</a>

    </div>

    <!-- Tabs -->
    <div id="fuTabs" class="flex gap-2 border-b border-gray-700 mb-3">
      <button id="fuTabOverdue" class="px-3 py-1.5 text-sm rounded-t bg-gray-900 text-red-300">Overdue</button>
      <button id="fuTabToday"   class="px-3 py-1.5 text-sm rounded-t bg-gray-900 text-gray-300">Today</button>
    </div>

    <!-- List -->
    <ul id="fuList" class="divide-y divide-gray-700 text-sm"></ul>

    <!-- Empty -->
    <div id="fuEmpty" class="text-gray-400 text-sm hidden">No follow-ups.</div>
  </div>
</section>



<!-- Recent activity -->
<section class="mt-6">
  <div class="bg-gray-800 rounded-xl p-4 shadow">
    <div class="flex items-center justify-between mb-2">
      <div class="text-sm text-gray-400">Recent activity</div>
      <!-- Redirect to the leads list. lead_logs.php is not meant to be accessed directly -->
      <a href="/admin/leads.php?tab=all&sort=newest" class="text-xs text-blue-400 hover:underline">View all</a>
    </div>
    <ul id="activityList" class="divide-y divide-gray-700 text-sm"></ul>
  </div>
</section>


<script type="module" src="/assets/js/dashboard.js"></script>
<?php
$mainContent = ob_get_clean();
include __DIR__ . '/base_layout.php';

